/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.DrawingHistoryEntry;
import DE.siemens.ad.logo.model.PropertiesIfc;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.ProgramException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class DrawingProperties
implements PropertiesIfc,
Serializable {
    static final long serialVersionUID = 2094473870177617071L;
    private int drawingPropertiesSerializedDataVersion = 3;
    protected List fDrawingHistory;
    protected List fDeletedHistory;
    public static final String PROP_PAGE_HOR = "pageHor";
    public static final String PROP_PAGE_VER = "pageVer";
    Date fCreationDate = new Date();
    Date fChangedDate = new Date();
    String fComment = "";
    String fCompany = "";
    String fCreator = "";
    String fCustomer = "";
    String fDiagramNumber = "";
    String fProjectName = "";
    String fChecked = "";
    String fInstallationName = "";
    String fVersionNumber = "1.0.0";
    boolean fShowAtNewFile = true;
    String fCompanyLogo = "";
    private String fPassword = null;
    private int fPagesHorizontal = -1;
    private int fPagesVertical = -1;
    private transient HashSet fChangeListener;
    protected String fProgramName = "";
    private boolean fLastAnalogOutputValue;
    private double fAnalogOutputFixedValue1;
    private double fAnalogOutputFixedValue2;
    private int fStartScreenSetting;
    private int fAnalogOutputType1 = 0;
    private int fAnalogOutputType2 = 0;
    private int fAnalogInput2_or_4 = 0;

    public DrawingProperties() {
        try {
            this.fShowAtNewFile = LogoProperties.instance().getBooleanProperty("showPropertyOnNew", true);
        }
        catch (Exception nfe) {
            this.fShowAtNewFile = true;
        }
        this.fCreator = System.getProperty("user.name", "");
        this.fLastAnalogOutputValue = true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeListeners().add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        HashSet set;
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        DrawingProperties drawingProperties = this;
        synchronized (drawingProperties) {
            set = (HashSet)this.getPropertyChangeListeners().clone();
        }
        Iterator e = set.iterator();
        while (e.hasNext()) {
            ((PropertyChangeListener)e.next()).propertyChange(event);
        }
    }

    public Date getChanged() {
        List list = this.getDrawingHistory();
        Date result = list.size() > 0 ? ((DrawingHistoryEntry)list.get(list.size() - 1)).getChangeDate() : this.fChangedDate;
        return result;
    }

    public String getChecked() {
        return this.fChecked;
    }

    public String getComment() {
        return this.fComment;
    }

    public String getCompany() {
        return this.fCompany;
    }

    public Date getCreated() {
        List list = this.getDrawingHistory();
        Date result = list.size() > 0 ? ((DrawingHistoryEntry)list.get(0)).getChangeDate() : this.fCreationDate;
        return result;
    }

    public int getAQType1() {
        return this.fAnalogOutputType1;
    }

    public void setAQType1(int AQType) {
        this.fAnalogOutputType1 = this.isAvailableValue(AQType) ? AQType : 0;
    }

    public int getAQType2() {
        return this.fAnalogOutputType2;
    }

    public void setAQType2(int AQType) {
        this.fAnalogOutputType2 = this.isAvailableValue(AQType) ? AQType : 0;
    }

    private boolean isAvailableValue(int AQType) {
        return AQType == 0 || AQType == 1;
    }

    public DrawingProperties getCopy() {
        DrawingProperties copy = new DrawingProperties();
        copy.setChanged();
        copy.setChecked(this.getChecked());
        copy.setComment(this.getComment());
        copy.setCompany(this.getCompany());
        copy.setCreator(this.getCreator());
        copy.setCustomer(this.getCustomer());
        copy.setDiagramnr(this.getDiagramnr());
        copy.setInstallationname(this.getInstallationname());
        copy.setPagesHorizontal(this.getPagesHorizontal());
        copy.setPagesVertical(this.getPagesVertical());
        copy.setPassword(this.getPassword());
        copy.setProgramName(this.getProgramName());
        copy.setProjectname(this.getProjectname());
        copy.setShowDialogAtNewFile(this.getShowDialogAtNewFile());
        copy.setVersion(this.getVersion());
        copy.setStartScreenSetting(this.getStartScreenSetting());
        copy.setAQType1(this.getAQType1());
        copy.setAQType2(this.getAQType2());
        copy.setAnalogOutputFixedValue1(this.getAnalogOutputFixedValue1());
        copy.setAnalogOutputFixedValue2(this.getAnalogOutputFixedValue2());
        copy.setAIPosition(this.getAIPosition());
        copy.setAnalogOutputLastValueStatus(this.getAnalogOutputLastValueStatus());
        return copy;
    }

    public void removeAllListeners() {
        this.fChangeListener = new HashSet();
    }

    public String getCreator() {
        return this.fCreator;
    }

    public String getCustomer() {
        return this.fCustomer;
    }

    public String getDiagramnr() {
        return this.fDiagramNumber;
    }

    public String getInstallationname() {
        return this.fInstallationName;
    }

    public int getPagesHorizontal() {
        if (this.fPagesHorizontal < 0) {
            this.fPagesHorizontal = LogoProperties.instance().getIntProperty("pagesHor", 1);
        }
        return this.fPagesHorizontal;
    }

    public int getPagesVertical() {
        if (this.fPagesVertical < 0) {
            this.fPagesVertical = LogoProperties.instance().getIntProperty("pagesVer", 1);
        }
        return this.fPagesVertical;
    }

    public String getPassword() {
        if (this.fPassword == null) {
            return "";
        }
        return this.fPassword;
    }

    public String getProgramName() {
        return this.fProgramName;
    }

    public String getProjectname() {
        return this.fProjectName;
    }

    protected HashSet getPropertyChangeListeners() {
        if (this.fChangeListener == null) {
            this.fChangeListener = new HashSet(5);
        }
        return this.fChangeListener;
    }

    public boolean getShowDialogAtNewFile() {
        return this.fShowAtNewFile;
    }

    public String getVersion() {
        return this.fVersionNumber;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.drawingPropertiesSerializedDataVersion < 2 && this.fProjectName != null) {
            this.setProgramName(this.fProjectName);
        }
        if (this.drawingPropertiesSerializedDataVersion < 3) {
            DrawingHistoryEntry drawingHistoryEntry = new DrawingHistoryEntry();
            drawingHistoryEntry.setUser(this.getCreator());
            drawingHistoryEntry.setSoftwareVersion(null);
            drawingHistoryEntry.setChangeDate(this.getCreated());
            this.addHistoryEntry(drawingHistoryEntry);
            drawingHistoryEntry = new DrawingHistoryEntry();
            drawingHistoryEntry.setUser("unknown");
            drawingHistoryEntry.setSoftwareVersion(null);
            drawingHistoryEntry.setChangeDate(this.getChanged());
            drawingHistoryEntry.setUser("");
            this.addHistoryEntry(drawingHistoryEntry);
        }
        this.drawingPropertiesSerializedDataVersion = 3;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeListeners().remove(listener);
    }

    public void savePages() throws ProgramException {
        LogoProperties ini = LogoProperties.instance();
        ini.setIntProperty("pagesHor", this.getPagesHorizontal());
        ini.setIntProperty("pagesVer", this.getPagesVertical());
        ini.saveProperties();
    }

    public void setChanged() {
        this.fChangedDate = new Date();
        DrawingHistoryEntry drawingHistoryEntry = null;
        List drawingHistory = this.getDrawingHistory();
        if (drawingHistory.size() > 0) {
            drawingHistoryEntry = (DrawingHistoryEntry)drawingHistory.get(drawingHistory.size() - 1);
        }
        if (drawingHistoryEntry == null || drawingHistoryEntry.isSaved()) {
            this.addHistoryEntry(new DrawingHistoryEntry());
        }
    }

    public void setChecked(String checked) {
        this.fChecked = checked;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }

    public void setCompany(String company) {
        this.fCompany = company;
    }

    public void setCreator(String creator) {
        this.fCreator = creator;
    }

    public void setCustomer(String customer) {
        this.fCustomer = customer;
    }

    public void setDiagramnr(String diagramnr) {
        this.fDiagramNumber = diagramnr;
    }

    public void setInstallationname(String installationname) {
        this.fInstallationName = installationname;
    }

    public void setPagesHorizontal(int newPagesHorizontal) {
        int oldValue = this.getPagesHorizontal();
        if (oldValue != newPagesHorizontal) {
            this.fPagesHorizontal = newPagesHorizontal;
            this.firePropertyChangeEvent(PROP_PAGE_HOR, new Integer(oldValue), new Integer(newPagesHorizontal));
        }
    }

    public void setPagesVertical(int newPagesVertical) {
        int oldValue = this.getPagesVertical();
        if (oldValue != newPagesVertical) {
            this.fPagesVertical = newPagesVertical;
            this.firePropertyChangeEvent(PROP_PAGE_VER, new Integer(oldValue), new Integer(newPagesVertical));
        }
    }

    public void setPassword(String newPassword) {
        this.fPassword = newPassword;
    }

    public void setProgramName(String newProgramName) {
        StringBuffer buffer = new StringBuffer();
        byte[] b = newProgramName.getBytes();
        for (int i = 0; i < b.length && i < 16; ++i) {
            if (b[i] < 32 || b[i] > 127) continue;
            buffer.append((char)b[i]);
        }
        this.fProgramName = buffer.toString();
    }

    public void setProjectname(String projectname) {
        this.fProjectName = projectname;
    }

    public void setShowDialogAtNewFile(boolean showDialogAtNewFile) {
        if (this.fShowAtNewFile != showDialogAtNewFile) {
            this.fShowAtNewFile = showDialogAtNewFile;
            LogoProperties.instance().setProperty("showPropertyOnNew", String.valueOf(this.fShowAtNewFile));
            LogoProperties.instance().saveProperties();
        }
    }

    public void setVersion(String version) {
        this.fVersionNumber = version;
    }

    public List getDrawingHistory() {
        if (this.fDrawingHistory == null) {
            this.fDrawingHistory = new ArrayList(5);
        }
        return this.fDrawingHistory;
    }

    public void addHistoryEntry(DrawingHistoryEntry drawingHistoryEntry) {
        this.getDrawingHistory().add(drawingHistoryEntry);
    }

    public void setDrawingHistory(List list) {
        this.fDrawingHistory = list;
    }

    public List getDeletedHistory() {
        if (this.fDeletedHistory == null) {
            this.fDeletedHistory = new ArrayList();
        }
        return this.fDeletedHistory;
    }

    public void setDeletedHistory(List deletedHistory) {
        this.fDeletedHistory = deletedHistory;
    }

    public boolean getAnalogOutputLastValueStatus() {
        return this.fLastAnalogOutputValue;
    }

    public void setAnalogOutputLastValueStatus(boolean value) {
        this.fLastAnalogOutputValue = value;
    }

    public double getAnalogOutputFixedValue1() {
        return this.fAnalogOutputFixedValue1;
    }

    public double getAnalogOutputFixedValue2() {
        return this.fAnalogOutputFixedValue2;
    }

    public void setAnalogOutputFixedValue1(double value) {
        this.fAnalogOutputFixedValue1 = value;
    }

    public void setAnalogOutputFixedValue2(double value) {
        this.fAnalogOutputFixedValue2 = value;
    }

    public void setStartScreenSetting(int value) {
        this.fStartScreenSetting = value;
    }

    public int getStartScreenSetting() {
        return this.fStartScreenSetting;
    }

    public int getAIPosition() {
        return this.fAnalogInput2_or_4;
    }

    public void setAIPosition(int AIPos) {
        this.fAnalogInput2_or_4 = AIPos;
    }
}

